//
//  GSSnapper.h
//  GlyphsLayerPluginOutline
//
//  Created by Georg Seifert on 24.01.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSNode;

@interface GSSnapper : NSObject

// The Origin of the Snapper.
@property (nonatomic) NSPoint from;
// If it is a line, the second value is set
@property (nonatomic) NSPoint to;
@property (nonatomic) BOOL open;
@property (nonatomic) CGFloat distance;
@property (nonatomic) BOOL required;
@property (nonatomic) CGFloat factor;

- (NSComparisonResult)compare:(id)element;

- (void)setDistanceToPoint:(NSPoint)point;

- (NSPoint)nearestPointForPoint:(NSPoint)point;

@end
